<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Archives - Mini Blog</title>
    <link href="CSS/archlogue.css" rel="stylesheet">
</head>
<body>
<header>
    <div class="logo"><a href="utilisateurlogue.php">Blogies</a></div>
    <div class="nav-buttons">
        <a class="deco" href="utilisateurlogue.php">Accueil</a>
        <a class="deco" href="deco.php">Déconnexion</a>
        <?php
        include("connexion.php");
        $stmt = $db->prepare("SELECT photo_profil FROM utilisateurs WHERE login = :login");
        $stmt->bindValue(':login', $_SESSION['login'], PDO::PARAM_STR);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $photo_profil = $result['photo_profil'] ?? "uploads/default.avif";
        echo "<a href='pp.php'><img src='" . htmlspecialchars($photo_profil) . "' class='photo-profil' alt='Photo de profil' style='width:40px;height:40px;border-radius:50%;'></a>";
        ?>
    </div>
</header>

<h2>Archives</h2>

<div class="container">
    <div class="grid-container">
        <?php
        $stmt = $db->query('SELECT * FROM billets ORDER BY date_post DESC');
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

        foreach ($result as $row) {
            $billet_id = $row["id"];

            echo "<div class='billet'>
                <h3>{$row['titre']}</h3>
                <p>Posté le : {$row['date_post']}</p>
                <p>Auteur : {$row['auteur']}</p>
                <a href='billets.php?id={$billet_id}' class='button'>Lire le contenu</a>
                </div>";  
        }
        ?>
    </div>
</div>

</body>
</html>